/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics.processing;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import stellarapi.api.lib.config.INBTConfig;
import stellarapi.api.lib.config.SimpleNBTConfig;
import stellarapi.api.lib.config.property.ConfigProperty;
import stellarapi.api.lib.config.property.ConfigPropertyList;

public class PossibleObservations
extends SimpleNBTConfig {
    public static final String categoryName = "Observations";
    private static PossibleObservations observations;
    private ConfigPropertyStringMap rewardProperty;

    public static PossibleObservations instance() {
        if (observations != null) {
            return observations;
        }
        observations = new PossibleObservations();
        return observations;
    }

    public PossibleObservations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"Sun", (Object)"/observe resetcount @p @o; /effect @p 15 3 1");
        builder.put((Object)"Moon", (Object)"/observe resetcount @p @o; /observe setwait @p @o 60s; /summon Enderman @x @y @z");
        builder.put((Object)"UMa79Zet", (Object)"/give @p iron_ingot 4");
        builder.put((Object)"Cep0Mu", (Object)"/give @p redstone 16");
        builder.put((Object)"Lyr4Eps", (Object)"/give @p iron_pickaxe 2; /give @p iron_ingot 8");
        builder.put((Object)"Andromeda Galaxy", (Object)"/observe resetcount @p @o; /observe setwait @p @o 100s; /give @p milk_bucket");
        builder.put((Object)"Orion Nebula", (Object)"/give @p potato 2; /give @p carrot 2");
        builder.put((Object)"Messier 7", (Object)"/observe resetcount @p @o; /observe setwait @p @o 5s; /give @p iron_ingot 1");
        builder.put((Object)"Messier 24", (Object)"/give @p iron_ingot 16");
        builder.put((Object)"Per7", (Object)"/observe resetcount @p @o; /observe setwait @p @o 5s; /give @p bone 1");
        builder.put((Object)"Trifid Nebula", (Object)"/observe resetcount @p @o; /observe setwait @p @o 20s; /give @p redstone 4; /give @p iron_ingot 1; /give @p dye 2 4");
        builder.put((Object)"Messier 15", (Object)"/give @p snowball 16");
        builder.put((Object)"Gem5", (Object)"/observe resetcount @p @o; /observe setwait @p @o 5s; /give @p iron_ingot 2");
        builder.put((Object)"Pup2", (Object)"/observe resetcount @p @o; /observe setwait @p @o 5s; /give @p iron_ingot 2");
        builder.put((Object)"Aur24Phi", (Object)"/observe resetcount @p @o; /observe setwait @p @o 5s; /give @p iron_ingot 2");
        builder.put((Object)"Ring Nebula", (Object)"/observe resetcount @p @o; /observe setwait @p @o 50s; /give @p redstone_block 2; /give @p glowstone 2; /give @p gold_ingot 4");
        builder.put((Object)"Crab Nebula", (Object)"/give @p nether_star; /give @p gold_block 8");
        builder.put((Object)"Triangulum Galaxy", (Object)"/give @p redstone_block 16; /give @p iron_block 8; /give @p gold_block 4; /give @p record_chirp");
        builder.put((Object)"Whirlpool Galaxy", (Object)"/observe resetcount @p @o; /observe setwait @p @o 60s; /give @p lapis_block 2; /give @p glowstone 4; /give @p gold_ingot 4");
        builder.put((Object)"Sunflower Galaxy", (Object)"/observe resetcount @p @o; /observe setwait @p @o 60s; /give @p quartz_block 4; /give @p gold_ingot 4");
        builder.put((Object)"Pinwheel Galaxy", (Object)"/give @p dragon_egg; /give @p diamond_block 4; /give @p gold_block 16");
        this.rewardProperty = new ConfigPropertyStringMap("Observation_Rewards", "observationRewards", (Map<String, String>)builder.build());
        this.addConfigProperty((ConfigProperty)this.rewardProperty);
    }

    public void setupConfig(Configuration config, String category) {
        config.setCategoryLanguageKey(category, "config.photoptics.category.observations");
        config.setCategoryComment(category, "Configuration for rewards when certain object is observed.");
        config.setCategoryRequiresWorldRestart(category, true);
        super.setupConfig(config, category);
        this.rewardProperty.setLanguageKey("config.photoptics.property.observations.rewardmap");
        this.rewardProperty.setComment("Rewards for Observation of objects.\nEach line should be in form of '(object name):(reward commands splitted by ';')'.");
        this.rewardProperty.setRequiresWorldRestart(true);
    }

    public Map<String, String> entryMap() {
        return this.rewardProperty.currentMap;
    }

    public INBTConfig copy() {
        PossibleObservations copied = new PossibleObservations();
        copied.applyCopy(this);
        return copied;
    }

    private class ConfigPropertyStringMap
    extends ConfigPropertyList {
        private Map<String, String> defaultMap;
        private Map<String, String> currentMap;
        private Function<Map.Entry<String, String>, String> merger;

        public ConfigPropertyStringMap(String configKey, String dataKey, Map<String, String> defaultValue) {
            super(configKey, dataKey);
            this.merger = new Function<Map.Entry<String, String>, String>(){

                public String apply(Map.Entry<String, String> input) {
                    return String.format("%s:%s", input.getKey(), input.getValue());
                }
            };
            this.defaultMap = defaultValue;
            this.setAsDefault();
        }

        protected Property.Type getType() {
            return Property.Type.STRING;
        }

        protected String[] getDefaultValues() {
            return Collections2.transform(this.defaultMap.entrySet(), this.merger).toArray(new String[0]);
        }

        protected void resizeValuesToLength(boolean fixed, int length) {
        }

        public void setAsDefault() {
            this.currentMap = Maps.newHashMap(this.defaultMap);
        }

        public void setAsProperty(ConfigProperty property) {
            if (property instanceof ConfigPropertyStringMap) {
                this.currentMap = Maps.newHashMap(((ConfigPropertyStringMap)property).currentMap);
            }
        }

        public void loadFromConfig() {
            String[] strList = this.property.getStringList();
            this.currentMap.clear();
            for (String entry : strList) {
                int index = entry.indexOf(58);
                this.currentMap.put(entry.substring(0, index), entry.substring(index + 1));
            }
        }

        public void saveToConfig() {
            this.property.set(Collections2.transform(this.currentMap.entrySet(), this.merger).toArray(new String[0]));
        }

        public void readFromNBT(NBTTagCompound compound) {
            NBTTagCompound tag = compound.func_74775_l(this.dataKey);
            this.currentMap.clear();
            for (String key : tag.func_150296_c()) {
                this.currentMap.put(key, tag.func_74779_i(key));
            }
        }

        public void writeToNBT(NBTTagCompound compound) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry<String, String> entry : this.currentMap.entrySet()) {
                tag.func_74778_a(entry.getKey(), entry.getValue());
            }
            compound.func_74782_a(this.dataKey, (NBTBase)tag);
        }
    }
}

