/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics.processing;

import abr.mod.photoptics.Photoptics;
import abr.mod.photoptics.processing.IObservationData;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stellarapi.api.CelestialPeriod;
import stellarapi.api.PeriodHelper;
import stellarapi.api.celestials.ICelestialObject;

public class PlayerObservationData
implements IObservationData {
    private Multiset<String> observedSet = HashMultiset.create();
    private Multiset<String> limitSet = HashMultiset.create();
    private Map<String, Long> lastTickObserved = Maps.newHashMap();
    private Map<String, Long> neededTickDuration = Maps.newHashMap();

    private long getUniversalTick() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_82737_E();
    }

    @Override
    public boolean onObserve(ICelestialObject object, EntityPlayer player) {
        String id = object.getName();
        if (!this.limitSet.contains((Object)id)) {
            this.limitSet.add((Object)id);
        }
        long currentTick = this.getUniversalTick();
        if (!this.neededTickDuration.containsKey(id)) {
            this.neededTickDuration.put(id, 20L);
        }
        if (this.lastTickObserved.containsKey(id) && this.lastTickObserved.get(id) + this.neededTickDuration.get(id) > currentTick) {
            long remainTick = this.lastTickObserved.get(id) + this.neededTickDuration.get(id) - currentTick;
            CelestialPeriod period = PeriodHelper.getDayPeriod((World)player.func_130014_f_());
            if (period != null && (double)remainTick > period.getPeriodLength()) {
                long day = (long)period.getPeriodLength();
                long dayLeft = remainTick / day;
                long secondLeft = remainTick % day / 20L;
                player.func_145747_a(this.withStyle((ITextComponent)new TextComponentTranslation("info.photoptics.observe.timeleftds", new Object[]{id, dayLeft, secondLeft})));
            } else {
                long secondLeft = remainTick / 20L;
                long tickLeft = remainTick % 20L;
                if (secondLeft > 0L) {
                    player.func_145747_a(this.withStyle((ITextComponent)new TextComponentTranslation("info.photoptics.observe.timeleftst", new Object[]{id, secondLeft, tickLeft})));
                } else {
                    player.func_145747_a(this.withStyle((ITextComponent)new TextComponentTranslation("info.photoptics.observe.timeleftt", new Object[]{id, tickLeft})));
                }
            }
            return false;
        }
        if (this.observedSet.count((Object)id) < this.limitSet.count((Object)id)) {
            this.observedSet.add((Object)id);
            this.lastTickObserved.put(id, currentTick);
            return true;
        }
        player.func_145747_a(this.withStyle((ITextComponent)new TextComponentTranslation("info.photoptics.observe.reachlimit", new Object[]{id, this.limitSet.count((Object)id)})));
        return false;
    }

    private ITextComponent withStyle(ITextComponent component) {
        return component.func_150255_a(component.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true)));
    }

    public NBTBase serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (String observed : this.limitSet) {
            NBTTagCompound observedInfo = new NBTTagCompound();
            observedInfo.func_74778_a("name", observed);
            observedInfo.func_74777_a("count", (short)this.observedSet.count((Object)observed));
            observedInfo.func_74777_a("limit", (short)this.limitSet.count((Object)observed));
            observedInfo.func_74772_a("time", this.lastTickObserved.get(observed).longValue());
            observedInfo.func_74772_a("duration", this.neededTickDuration.get(observed).longValue());
            tagList.func_74742_a((NBTBase)observedInfo);
        }
        compound.func_74782_a("observedInfo", (NBTBase)tagList);
        return compound;
    }

    public void deserializeNBT(NBTBase nbt) {
        this.observedSet.clear();
        this.limitSet.clear();
        this.lastTickObserved.clear();
        NBTTagList tagList = ((NBTTagCompound)nbt).func_150295_c("observedInfo", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound observedInfo = tagList.func_150305_b(i);
            String observed = observedInfo.func_74779_i("name");
            this.observedSet.setCount((Object)observed, (int)observedInfo.func_74765_d("count"));
            this.limitSet.setCount((Object)observed, (int)observedInfo.func_74765_d("limit"));
            this.lastTickObserved.put(observed, observedInfo.func_74763_f("time"));
            this.neededTickDuration.put(observed, observedInfo.func_74763_f("duration"));
        }
    }

    @Override
    public void reset(String objectID, short count) {
        this.observedSet.setCount((Object)objectID, (int)count);
        Photoptics.logger.info(String.format("Count reset for %s to %d", objectID, count));
        if (this.limitSet.count((Object)objectID) < count) {
            this.limitSet.setCount((Object)objectID, (int)count);
        }
    }

    @Override
    public void setLimit(String objectID, short limit) {
        this.limitSet.setCount((Object)objectID, (int)limit);
    }

    @Override
    public void setWaitDuration(String objectID, long waitDuration) {
        this.neededTickDuration.put(objectID, waitDuration);
    }
}

