/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics.item;

import abr.mod.photoptics.Photoptics;
import abr.mod.photoptics.item.ItemBasicBinoculars;
import abr.mod.photoptics.item.ItemBasicHandheldTelescope;
import abr.mod.photoptics.item.ItemTelescopeBase;
import abr.mod.photoptics.item.TelescopeMaterial;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum PhotopticsItems {
    INSTANCE;

    public final CreativeTabs tabPhotoptics = new CreativeTabs("photoptics"){

        public ItemStack func_78016_d() {
            return new ItemStack(PhotopticsItems.this.basicBinoculars);
        }
    };
    public TelescopeMaterial basic;
    public TelescopeMaterial gold;
    public TelescopeMaterial diamondGreen;
    public TelescopeMaterial diamondBlue;
    public TelescopeMaterial diamondRed;
    public TelescopeMaterial ultimate;
    public Item basicBinoculars;
    public Item basicHandheldTelescope;
    public List<ItemTelescopeBase> binocularsList = Lists.newArrayList();
    public List<ItemTelescopeBase> handheldTelescopeList = Lists.newArrayList();

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> itemRegistry) {
        INSTANCE.registerItems(itemRegistry);
        Photoptics.proxy.registerRenderers();
    }

    private void registerItems(RegistryEvent.Register<Item> itemRegistry) {
        TelescopeMaterial material;
        IForgeRegistry registry = itemRegistry.getRegistry();
        this.basic = new TelescopeMaterial("basic", 0.6, 0.7, 0.8, "basic_materials", 1.0, 1.2);
        this.gold = new TelescopeMaterial("gold", 0.9, 0.8, 0.5, "gold_material", 3.5, 2.0);
        this.diamondGreen = new TelescopeMaterial("diamondGreen", 0.3, 1.0, 0.3, "diamond_green", 7.0, 2.5);
        this.diamondBlue = new TelescopeMaterial("diamondBlue", 0.3, 0.3, 1.0, "diamond_blue", 7.0, 2.5);
        this.diamondRed = new TelescopeMaterial("diamondRed", 1.0, 0.3, 0.3, "diamond_red", 7.0, 2.5);
        this.ultimate = new TelescopeMaterial("ultimate", 0.5, 1.0, 0.5, "ultimate", 90.0, 5.0);
        this.addMaterialItem(this.basic);
        this.addMaterialItem(this.gold);
        this.addMaterialItem(this.diamondGreen);
        this.addMaterialItem(this.diamondBlue);
        this.addMaterialItem(this.diamondRed);
        this.addMaterialItem(this.ultimate);
        for (ItemTelescopeBase binoculars : this.binocularsList) {
            material = binoculars.getTelescopeMaterial();
            if (material == this.basic) {
                this.basicBinoculars = binoculars;
                binoculars.setTelescopeRegistryName(new ResourceLocation("photoptics", "photopticsbasicbinoculars"));
            }
            binoculars.preRegister();
            registry.register((IForgeRegistryEntry)binoculars);
        }
        for (ItemTelescopeBase handheldTelescope : this.handheldTelescopeList) {
            material = handheldTelescope.getTelescopeMaterial();
            if (material == this.basic) {
                this.basicHandheldTelescope = handheldTelescope;
                handheldTelescope.setTelescopeRegistryName(new ResourceLocation("photoptics", "basichandheldtelescope"));
            }
            handheldTelescope.preRegister();
            registry.register((IForgeRegistryEntry)handheldTelescope);
        }
    }

    public void addMaterialItem(TelescopeMaterial material) {
        this.binocularsList.add((ItemTelescopeBase)new ItemBasicBinoculars().setTelescopeMaterial(material).setTelescopeRegistryName(new ResourceLocation("photoptics", String.format("binoculars_%s", material.name.toLowerCase()))).func_77655_b(String.format("photoptics.binoculars.%s", material.name)).func_77637_a(this.tabPhotoptics).func_77625_d(1));
        this.handheldTelescopeList.add((ItemTelescopeBase)new ItemBasicHandheldTelescope().setTelescopeMaterial(material).setTelescopeRegistryName(new ResourceLocation("photoptics", String.format("handheldtelescope_%s", material.name.toLowerCase()))).func_77655_b(String.format("photoptics.handheldtelescope.%s", material.name)).func_77637_a(this.tabPhotoptics).func_77625_d(1));
    }
}

