/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics.item;

import abr.mod.photoptics.EnumPhotopticsKeys;
import abr.mod.photoptics.PhotopticsTelescopeHandler;
import abr.mod.photoptics.item.ITelescopeProperty;
import abr.mod.photoptics.item.ItemTelescopeBase;
import abr.mod.photoptics.render.overlay.IOverlayRenderer;
import abr.mod.photoptics.render.overlay.OverlayTelescopeRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stellarapi.api.SAPIReferences;
import stellarapi.api.lib.math.Spmath;
import stellarapi.api.optics.IOpticalFilter;
import stellarapi.api.optics.IViewScope;
import stellarapi.api.optics.Wavelength;

public class ItemBasicHandheldTelescope
extends ItemTelescopeBase {
    private static final int maxZoomInitial = 20;

    public int getMaxZoom() {
        return 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOverlayRenderer getOverlayRenderer(ItemStack stack) {
        return new OverlayTelescopeRenderer();
    }

    @Override
    public ITelescopeProperty getOpticalProperty(ItemStack stack) {
        return new HandheldTelescopeOpticalProperty();
    }

    private class HandheldTelescopeOpticalProperty
    implements ITelescopeProperty {
        private byte zoom;

        private HandheldTelescopeOpticalProperty() {
        }

        public boolean isFilter() {
            return true;
        }

        public IOpticalFilter getFilter(EntityLivingBase viewer) {
            return new IOpticalFilter(){

                public double getFilterEfficiency(Wavelength wavelength) {
                    return ItemBasicHandheldTelescope.this.getTelescopeMaterial().filterProperty.apply(wavelength);
                }
            };
        }

        public boolean isScope() {
            return true;
        }

        public IViewScope getScope(EntityLivingBase viewer) {
            return new IViewScope(){

                public double getLGP() {
                    double mult = ItemBasicHandheldTelescope.this.getTelescopeMaterial().lumMultiplier;
                    if (ItemBasicHandheldTelescope.this.getTelescopeMaterial().zoomMultiplier >= 2.0) {
                        mult *= Spmath.sqr((double)(1.0 + (double)HandheldTelescopeOpticalProperty.this.zoom / 15.0));
                    }
                    return 30.0 * mult;
                }

                public double getResolution(Wavelength wl) {
                    double zoomFactor = 1.0 + (double)HandheldTelescopeOpticalProperty.this.zoom / 15.0;
                    return 0.036 / Math.sqrt(zoomFactor) / ItemBasicHandheldTelescope.this.getTelescopeMaterial().zoomMultiplier;
                }

                public double getMP() {
                    return 3.0 * (1.0 + (double)HandheldTelescopeOpticalProperty.this.zoom / 15.0) * ItemBasicHandheldTelescope.this.getTelescopeMaterial().zoomMultiplier;
                }

                public boolean forceChange() {
                    return true;
                }

                public boolean isFOVCoverSky() {
                    return true;
                }
            };
        }

        @Override
        public void keyControl(EnumPhotopticsKeys key, EntityPlayer controller) {
            if (key == EnumPhotopticsKeys.ZoomIn && this.zoom < ItemBasicHandheldTelescope.this.getMaxZoom()) {
                this.zoom = (byte)(this.zoom + 1);
                SAPIReferences.updateScope((Entity)controller, (Object[])new Object[0]);
            } else if (key == EnumPhotopticsKeys.ZoomOut && this.zoom > 0) {
                this.zoom = (byte)(this.zoom - 1);
                SAPIReferences.updateScope((Entity)controller, (Object[])new Object[0]);
            } else if (key == EnumPhotopticsKeys.Observe) {
                PhotopticsTelescopeHandler.onObserve(controller, 1.5 / ItemBasicHandheldTelescope.this.getTelescopeMaterial().zoomMultiplier);
            }
        }

        public NBTBase serializeNBT() {
            return new NBTTagByte(this.zoom);
        }

        public void deserializeNBT(NBTBase nbt) {
            this.zoom = ((NBTPrimitive)nbt).func_150290_f();
        }
    }
}

