/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics.item;

import abr.mod.photoptics.EnumPhotopticsKeys;
import abr.mod.photoptics.item.ITelescopeProperty;
import abr.mod.photoptics.item.ItemTelescopeBase;
import abr.mod.photoptics.render.overlay.IOverlayRenderer;
import abr.mod.photoptics.render.overlay.OverlayBinocularsRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stellarapi.api.SAPIReferences;
import stellarapi.api.optics.IOpticalFilter;
import stellarapi.api.optics.IViewScope;
import stellarapi.api.optics.Wavelength;

public class ItemBasicBinoculars
extends ItemTelescopeBase {
    public static final int maxZoom = 5;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOverlayRenderer getOverlayRenderer(ItemStack stack) {
        return new OverlayBinocularsRenderer();
    }

    @Override
    public ITelescopeProperty getOpticalProperty(ItemStack stack) {
        return new BinocularsOpticalProperty();
    }

    private class BinocularsOpticalProperty
    implements ITelescopeProperty {
        private byte zoom;

        private BinocularsOpticalProperty() {
        }

        public boolean isFilter() {
            return true;
        }

        public IOpticalFilter getFilter(EntityLivingBase viewer) {
            return new IOpticalFilter(){

                public double getFilterEfficiency(Wavelength wavelength) {
                    return ItemBasicBinoculars.this.getTelescopeMaterial().filterProperty.apply(wavelength);
                }
            };
        }

        public boolean isScope() {
            return true;
        }

        public IViewScope getScope(EntityLivingBase viewer) {
            return new IViewScope(){

                public double getLGP() {
                    return 20.0 * ItemBasicBinoculars.this.getTelescopeMaterial().lumMultiplier;
                }

                public double getResolution(Wavelength wl) {
                    return 0.036 / Math.sqrt(1.0 + (double)BinocularsOpticalProperty.this.zoom / 10.0) / ItemBasicBinoculars.this.getTelescopeMaterial().zoomMultiplier;
                }

                public double getMP() {
                    return 3.0 * (1.0 + (double)BinocularsOpticalProperty.this.zoom / 10.0) * ItemBasicBinoculars.this.getTelescopeMaterial().zoomMultiplier;
                }

                public boolean forceChange() {
                    return true;
                }

                public boolean isFOVCoverSky() {
                    return true;
                }
            };
        }

        @Override
        public void keyControl(EnumPhotopticsKeys key, EntityPlayer controller) {
            if (key == EnumPhotopticsKeys.ZoomIn && this.zoom < 5) {
                this.zoom = (byte)(this.zoom + 1);
                SAPIReferences.updateScope((Entity)controller, (Object[])new Object[0]);
            } else if (key == EnumPhotopticsKeys.ZoomOut && this.zoom > 0) {
                this.zoom = (byte)(this.zoom - 1);
                SAPIReferences.updateScope((Entity)controller, (Object[])new Object[0]);
            }
        }

        public NBTBase serializeNBT() {
            return new NBTTagByte(this.zoom);
        }

        public void deserializeNBT(NBTBase nbt) {
            this.zoom = ((NBTPrimitive)nbt).func_150290_f();
        }
    }
}

