/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics;

import abr.mod.photoptics.EnumPhotopticsKeys;
import abr.mod.photoptics.Photoptics;
import abr.mod.photoptics.item.ITelescopeProperty;
import abr.mod.photoptics.processing.IObservationData;
import abr.mod.photoptics.processing.PlayerDataProvider;
import abr.mod.photoptics.processing.PossibleObservations;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import stellarapi.api.SAPICapabilities;
import stellarapi.api.SAPIReferences;
import stellarapi.api.celestials.CelestialCollectionManager;
import stellarapi.api.celestials.ICelestialObject;
import stellarapi.api.interact.IOpticalProperties;
import stellarapi.api.lib.math.SpCoord;
import stellarapi.api.optics.IViewScope;

public class PhotopticsTelescopeHandler {
    public static void onKeyInput(EntityPlayer player, EnumPhotopticsKeys key) {
        IOpticalProperties capability;
        ItemStack usingItem = player.func_184607_cu();
        if (usingItem != null && usingItem.hasCapability(SAPICapabilities.OPTICAL_PROPERTY, EnumFacing.UP) && (capability = (IOpticalProperties)usingItem.getCapability(SAPICapabilities.OPTICAL_PROPERTY, EnumFacing.UP)) instanceof ITelescopeProperty) {
            ITelescopeProperty property = (ITelescopeProperty)capability;
            property.keyControl(key, player);
        }
    }

    public static void onObserve(EntityPlayer player, double observeRange) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        float rotationYaw = player.field_70177_z;
        float rotationPitch = -player.field_70125_A;
        SpCoord currentDirection = new SpCoord((double)(-rotationYaw) % 360.0, (double)rotationPitch);
        CelestialCollectionManager manager = SAPIReferences.getCollectionManager((World)player.field_70170_p);
        IViewScope scope = SAPIReferences.getScope((Entity)player);
        if (manager != null && scope != null) {
            for (ICelestialObject object : manager.findAllObjectsInRange(currentDirection, observeRange)) {
                double magnitude = object.getStandardMagnitude();
                if ((magnitude -= 2.5 * Math.log10(scope.getLGP())) > 6.0) continue;
                String name = object.getName();
                String command = PossibleObservations.instance().entryMap().get(name);
                Photoptics.logger.info(name);
                if (command == null || !((IObservationData)player.getCapability(PlayerDataProvider.OBSERVATION_DATA, EnumFacing.UP)).onObserve(object, player)) continue;
                MinecraftServer server = player.func_184102_h();
                for (String splitted : command.split(";")) {
                    splitted = splitted.replace("@p", player.func_110124_au().toString()).replace("@o", name.replace(' ', '_')).replace("@x", String.valueOf(MathHelper.func_76128_c((double)player.field_70165_t))).replace("@y", String.valueOf(MathHelper.func_76128_c((double)player.field_70163_u))).replace("@z", String.valueOf(MathHelper.func_76128_c((double)player.field_70161_v))).trim();
                    server.func_71187_D().func_71556_a((ICommandSender)server, splitted);
                }
                Photoptics.logger.info("Found");
                return;
            }
            Photoptics.logger.info("Ended search");
        }
    }
}

