/*
 * Decompiled with CFR 0.152.
 */
package abr.mod.photoptics;

import abr.mod.photoptics.CommonProxy;
import abr.mod.photoptics.PhotopticsFMLEventHandler;
import abr.mod.photoptics.PhotopticsForgeEventHandler;
import abr.mod.photoptics.StellarAPIEventHandler;
import abr.mod.photoptics.TickEventHandler;
import abr.mod.photoptics.command.CommandObserve;
import abr.mod.photoptics.item.PhotopticsItems;
import abr.mod.photoptics.network.PhotopticsNetworkHandler;
import abr.mod.photoptics.processing.PossibleObservations;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;
import stellarapi.api.SAPIReferences;
import stellarapi.api.lib.config.ConfigManager;
import stellarapi.api.lib.config.IConfigHandler;

@Mod(modid="photoptics", version="1.12.2-0.1.1.1", acceptedMinecraftVersions="[1.12.0, 1.13.0)", dependencies="required-after:stellarapi@[1.12.2-0.4.2.1, 1.12.2-0.4.3.0)", guiFactory="abr.mod.photoptics.config.POConfigGuiFactory")
public class Photoptics {
    public static final String modid = "photoptics";
    public static final String resourceid = "photoptics";
    public static final String version = "1.12.2-0.1.1.1";
    @Mod.Instance(value="photoptics")
    public static Photoptics instance;
    @SidedProxy(clientSide="abr.mod.photoptics.ClientProxy", serverSide="abr.mod.photoptics.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    private PhotopticsNetworkHandler networkHandler = new PhotopticsNetworkHandler();
    private ConfigManager manager;

    public PhotopticsNetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        this.manager = new ConfigManager(config);
        SAPIReferences.getEventBus().register((Object)new StellarAPIEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TickEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PhotopticsForgeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PhotopticsFMLEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)PhotopticsItems.INSTANCE);
        this.networkHandler.register();
        this.manager.register("Observations", (IConfigHandler)PossibleObservations.instance());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException {
        this.manager.syncFromFile();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandObserve());
    }

    public ConfigManager getConfigManager() {
        return this.manager;
    }
}

