/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.EnumSet;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CATEGORY_FORMATTING = "formatting";
    private final ForgeConfigSpec config;
    private final ForgeConfigSpec.ConfigValue<String> modNameFormatFriendly;
    @Nullable
    private String cachedModNameFormat;

    public Config() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        EnumSet<TextFormatting> validFormatting = EnumSet.allOf(TextFormatting.class);
        validFormatting.remove(TextFormatting.RESET);
        String validValues = validFormatting.stream().map(formatting -> formatting.func_96297_d().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(", "));
        builder.push(CATEGORY_FORMATTING);
        this.modNameFormatFriendly = builder.comment(new String[]{"How the mod name should be formatted in the tooltip. Leave blank to disable. Valid values:", validValues}).translation("config.modnametooltip.formatting.modNameFormat").define("modNameFormat", (Object)"blue italic");
        this.config = builder.build();
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.config;
    }

    public String getModNameFormat() {
        if (this.cachedModNameFormat == null) {
            this.cachedModNameFormat = Config.parseFriendlyModNameFormat((String)this.modNameFormatFriendly.get());
        }
        return this.cachedModNameFormat;
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            TextFormatting valueByName = TextFormatting.func_96300_b((String)string);
            if (valueByName != null) {
                format.append(valueByName.toString());
                continue;
            }
            LOGGER.error("Invalid format: " + string);
        }
        return format.toString();
    }

    public void onConfigChanged(ModConfig.Reloading eventArgs) {
        if ("modnametooltip".equals(eventArgs.getConfig().getModId())) {
            this.cachedModNameFormat = null;
        }
    }
}

