/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.List;
import javax.annotation.Nullable;
import mezz.modnametooltip.Config;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class TooltipEventHandler {
    private final Config config;

    public TooltipEventHandler(Config config) {
        this.config = config;
    }

    public void onToolTip(ItemTooltipEvent event) {
        List toolTip;
        ItemStack itemStack;
        String modName;
        String modNameFormat = this.config.getModNameFormat();
        if (!modNameFormat.isEmpty() && (modName = TooltipEventHandler.getModName(itemStack = event.getItemStack())) != null && !TooltipEventHandler.isModNameAlreadyPresent(toolTip = event.getToolTip(), modName)) {
            toolTip.add(new StringTextComponent(modNameFormat + modName));
        }
    }

    @Nullable
    private static String getModName(ItemStack itemStack) {
        Item item;
        String modId;
        if (!itemStack.func_190926_b() && (modId = (item = itemStack.func_77973_b()).getCreatorModId(itemStack)) != null) {
            return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
        }
        return null;
    }

    private static boolean isModNameAlreadyPresent(List<ITextComponent> tooltip, String modName) {
        if (tooltip.size() > 1) {
            ITextComponent line = tooltip.get(tooltip.size() - 1);
            String lineString = line.getString();
            String withoutFormatting = TextFormatting.func_110646_a((String)lineString);
            return modName.equals(withoutFormatting);
        }
        return false;
    }
}

