/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockUtils;
import baritone.api.utils.accessor.IItemStack;
import com.google.common.collect.ImmutableSet;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3286;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_39;
import net.minecraft.class_3902;
import net.minecraft.class_3949;
import net.minecraft.class_4567;
import net.minecraft.class_47;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5819;
import net.minecraft.class_60;
import net.minecraft.class_6756;
import net.minecraft.class_6861;
import net.minecraft.class_7699;
import net.minecraft.server.MinecraftServer;
import sun.misc.Unsafe;

public final class BlockOptionalMeta {
    private final class_2248 block;
    private final Set<class_2680> blockstates;
    private final ImmutableSet<Integer> stateHashes;
    private final ImmutableSet<Integer> stackHashes;
    private static final Pattern pattern = Pattern.compile("^(.+?)(?::(\\d+))?$");
    private static class_60 lootTables;
    private static class_4567 predicate;
    private static Map<class_2248, List<class_1792>> drops;
    private static Method getVanillaServerPack;

    public BlockOptionalMeta(@Nonnull class_2248 class_22482) {
        this.block = class_22482;
        this.blockstates = BlockOptionalMeta.getStates(class_22482);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    public BlockOptionalMeta(@Nonnull String object) {
        object = pattern.matcher((CharSequence)object);
        if (!((Matcher)object).find()) {
            throw new IllegalArgumentException("invalid block selector");
        }
        object = ((Matcher)object).toMatchResult();
        this.block = BlockUtils.stringToBlockRequired(object.group(1));
        this.blockstates = BlockOptionalMeta.getStates(this.block);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    private static Set<class_2680> getStates(@Nonnull class_2248 class_22482) {
        return new HashSet<class_2680>((Collection<class_2680>)class_22482.method_9595().method_11662());
    }

    private static ImmutableSet<Integer> getStateHashes(Set<class_2680> set) {
        return ImmutableSet.copyOf((Object[])((Integer[])set.stream().map(Object::hashCode).toArray(Integer[]::new)));
    }

    private static ImmutableSet<Integer> getStackHashes(Set<class_2680> set) {
        return ImmutableSet.copyOf((Object[])((Integer[])set.stream().flatMap(class_26802 -> BlockOptionalMeta.drops(class_26802.method_26204()).stream().map(class_17922 -> new class_1799((class_1935)class_17922, 1))).map(class_17992 -> ((IItemStack)class_17992).getBaritoneHash()).toArray(Integer[]::new)));
    }

    public final class_2248 getBlock() {
        return this.block;
    }

    public final boolean matches(@Nonnull class_2248 class_22482) {
        return class_22482 == this.block;
    }

    public final boolean matches(@Nonnull class_2680 class_26802) {
        return class_26802.method_26204() == this.block && this.stateHashes.contains((Object)class_26802.hashCode());
    }

    public final boolean matches(class_1799 class_17992) {
        int n = ((IItemStack)class_17992).getBaritoneHash() - class_17992.method_7919();
        return this.stackHashes.contains((Object)n);
    }

    public final String toString() {
        return String.format("BlockOptionalMeta{block=%s}", this.block);
    }

    public final class_2680 getAnyBlockState() {
        if (this.blockstates.size() > 0) {
            return this.blockstates.iterator().next();
        }
        return null;
    }

    private static class_3268 getVanillaServerPack() {
        if (getVanillaServerPack == null) {
            getVanillaServerPack = Arrays.stream(class_3286.class.getDeclaredMethods()).filter(method -> method.getReturnType() == class_3268.class).findFirst().orElseThrow();
            getVanillaServerPack.setAccessible(true);
        }
        try {
            return (class_3268)getVanillaServerPack.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static class_60 getManager() {
        if (lootTables == null) {
            class_6861 class_68612 = new class_6861(class_3264.field_14190, List.of(BlockOptionalMeta.getVanillaServerPack()));
            class_3304 class_33042 = new class_3304(class_3264.field_14190);
            lootTables = new class_60(predicate);
            class_33042.method_14477((class_3302)lootTables);
            try {
                class_33042.method_18232((Executor)new ThreadPerTaskExecutor(Thread::new), (Executor)new ThreadPerTaskExecutor(Thread::new), CompletableFuture.completedFuture(class_3902.field_17274), class_68612.method_29213().toList()).method_18364().get();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return lootTables;
    }

    public static class_4567 getPredicateManager() {
        return predicate;
    }

    private static synchronized List<class_1792> drops(class_2248 class_22483) {
        return drops.computeIfAbsent(class_22483, class_22482 -> {
            class_2960 class_29602 = class_22482.method_26162();
            if (class_29602 == class_39.field_844) {
                return Collections.emptyList();
            }
            ArrayList arrayList = new ArrayList();
            try {
                BlockOptionalMeta.getManager().method_367(class_29602).method_320(new class_47.class_48((class_3218)ServerLevelStub.fastCreate()).method_311(class_5819.method_43047()).method_312(class_181.field_24424, (Object)class_243.method_24954((class_2382)class_2338.field_10980)).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_306(class_181.field_1228, null).method_312(class_181.field_1224, (Object)class_22482.method_9564()).method_309(class_173.field_1172), class_17992 -> arrayList.add(class_17992.method_7909()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        });
    }

    static {
        predicate = new class_4567();
        drops = new HashMap<class_2248, List<class_1792>>();
    }

    static class ServerLevelStub
    extends class_3218 {
        private static class_310 client = class_310.method_1551();
        private static Unsafe unsafe = ServerLevelStub.getUnsafe();

        public ServerLevelStub(MinecraftServer minecraftServer, Executor executor, class_32.class_5143 class_51432, class_5268 class_52682, class_5321<class_1937> class_53212, class_5363 class_53632, class_3949 class_39492, boolean bl, long l, List<class_5304> list, boolean bl2) {
            super(minecraftServer, executor, class_51432, class_52682, class_53212, class_53632, class_39492, bl, l, list, bl2);
        }

        public class_7699 method_45162() {
            assert (ServerLevelStub.client.field_1687 != null);
            return ServerLevelStub.client.field_1687.method_45162();
        }

        public static ServerLevelStub fastCreate() {
            try {
                return (ServerLevelStub)((Object)unsafe.allocateInstance(ServerLevelStub.class));
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
        }

        public static Unsafe getUnsafe() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public /* synthetic */ class_2802 method_8398() {
            return super.method_14178();
        }

        public /* synthetic */ class_6756 method_8405() {
            return super.method_14179();
        }

        public /* synthetic */ class_6756 method_8397() {
            return super.method_14196();
        }

        public /* synthetic */ class_2791 method_8392(int n, int n2) {
            return super.method_8497(n, n2);
        }

        public /* synthetic */ class_269 method_8428() {
            return super.method_14170();
        }
    }
}

