/*
 * Decompiled with CFR 0.152.
 */
package baritone.cache;

import baritone.Baritone;
import baritone.api.BaritoneAPI;
import baritone.api.IBaritone;
import baritone.api.cache.ICachedRegion;
import baritone.api.cache.ICachedWorld;
import baritone.api.cache.IWorldData;
import baritone.api.utils.Helper;
import baritone.cache.CachedChunk;
import baritone.cache.CachedRegion;
import baritone.cache.ChunkPacker;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_2874;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CachedWorld
implements ICachedWorld,
Helper {
    private Long2ObjectMap<CachedRegion> a;
    private final String a;
    final LinkedBlockingQueue<class_1923> a;
    final Map<class_1923, class_2818> a;
    private final class_2874 a = new ConcurrentHashMap();

    CachedWorld(Path path, class_2874 class_28742) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {}
        }
        this.a = path.toString();
        this.a = class_28742;
        System.out.println("Cached world directory: " + path);
        Baritone.a().execute(new PackerThread(this));
        Baritone.a().execute(() -> {
            try {
                Thread.sleep(30000L);
                while (true) {
                    this.save();
                    Thread.sleep(600000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        });
    }

    @Override
    public final void queueForPacking(class_2818 class_28182) {
        if (this.a.put(class_28182.method_12004(), class_28182) == null) {
            this.a.add((CachedRegion)class_28182.method_12004());
        }
    }

    @Override
    public final boolean isCached(int n, int n2) {
        CachedRegion cachedRegion = this.a(n >> 9, n2 >> 9);
        if (cachedRegion == null) {
            return false;
        }
        return cachedRegion.isCached(n & 0x1FF, n2 & 0x1FF);
    }

    @Override
    public final ArrayList<class_2338> getLocationsOf(String string, int n, int n2, int n3, int n4) {
        ArrayList<class_2338> arrayList = new ArrayList<class_2338>();
        n2 >>= 9;
        n3 >>= 9;
        for (int i = 0; i <= n4; ++i) {
            for (int j = -i; j <= i; ++j) {
                for (int k = -i; k <= i; ++k) {
                    int n5;
                    int n6;
                    CachedRegion cachedRegion;
                    int n7 = j;
                    int n8 = k;
                    if (n7 * n7 + n8 * n8 != i || (cachedRegion = this.b(n6 = j + n2, n5 = k + n3)) == null) continue;
                    arrayList.addAll(cachedRegion.a(string));
                }
            }
            if (arrayList.size() < n) continue;
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public final void save() {
        if (!((Boolean)Baritone.a().chunkCaching.value).booleanValue()) {
            System.out.println("Not saving to disk; chunk caching is disabled.");
            this.a().forEach(cachedRegion -> {
                if (cachedRegion != null) {
                    cachedRegion.a();
                }
            });
            this.a();
            return;
        }
        long l = System.nanoTime() / 1000000L;
        this.a().parallelStream().forEach(cachedRegion -> {
            if (cachedRegion != null) {
                cachedRegion.a(this.a);
            }
        });
        long l2 = System.nanoTime() / 1000000L;
        System.out.println("World save took " + (l2 - l) + "ms");
        this.a();
    }

    private synchronized void a() {
        class_2338 class_23382;
        Object object;
        block5: {
            if (!((Boolean)Baritone.a().pruneRegionsFromRAM.value).booleanValue()) {
                return;
            }
            object = this;
            for (IBaritone object2 : BaritoneAPI.getProvider().getAllBaritones()) {
                IWorldData iWorldData = object2.getWorldProvider().getCurrentWorld();
                if (iWorldData == null || iWorldData.getCachedWorld() != object || object2.getPlayerContext().player() == null) continue;
                class_23382 = object2.getPlayerContext().playerFeet();
                break block5;
            }
            Object object4 = null;
            for (CachedRegion cachedRegion : ((CachedWorld)object).a()) {
                if (cachedRegion == null || (object = cachedRegion.a()) == null || object4 != null && ((CachedChunk)object4).a >= ((CachedChunk)object).a) continue;
                object4 = object;
            }
            class_23382 = object4 == null ? new class_2338(0, 0, 0) : new class_2338((((CachedChunk)object4).b << 4) + 8, 0, (((CachedChunk)object4).c << 4) + 8);
        }
        object = class_23382;
        for (CachedRegion cachedRegion : this.a()) {
            if (cachedRegion == null) continue;
            int n = (cachedRegion.getX() << 9) + 256 - object.method_10263();
            int n2 = (cachedRegion.getZ() << 9) + 256 - object.method_10260();
            int n3 = n;
            int n4 = n2;
            if (!(Math.sqrt(n3 * n3 + n4 * n4) > 1024.0)) continue;
            if (!((Boolean)Baritone.a().censorCoordinates.value).booleanValue()) {
                this.logDebug("Deleting cached region " + cachedRegion.getX() + "," + cachedRegion.getZ() + " from ram");
            }
            this.a.remove(CachedWorld.a(cachedRegion.getX(), cachedRegion.getZ()));
        }
    }

    private synchronized List<CachedRegion> a() {
        return new ArrayList<CachedRegion>((Collection<CachedRegion>)this.a.values());
    }

    @Override
    public final void reloadAllFromDisk() {
        long l = System.nanoTime() / 1000000L;
        this.a().forEach(cachedRegion -> {
            if (cachedRegion != null) {
                cachedRegion.b(this.a);
            }
        });
        long l2 = System.nanoTime() / 1000000L;
        System.out.println("World load took " + (l2 - l) + "ms");
    }

    public final synchronized CachedRegion a(int n, int n2) {
        return (CachedRegion)this.a.get(CachedWorld.a(n, n2));
    }

    public final synchronized CachedRegion b(int n, int n2) {
        return (CachedRegion)this.a.computeIfAbsent(CachedWorld.a(n, n2), l -> {
            CachedRegion cachedRegion = new CachedRegion(n, n2, this.a);
            cachedRegion.b(this.a);
            return cachedRegion;
        });
    }

    private static long a(int n, int n2) {
        if (!CachedWorld.a(n, n2)) {
            return 0L;
        }
        return (long)n & 0xFFFFFFFFL | ((long)n2 & 0xFFFFFFFFL) << 32;
    }

    private static boolean a(int n, int n2) {
        return n <= 58594 && n >= -58594 && n2 <= 58594 && n2 >= -58594;
    }

    @Override
    public final /* synthetic */ ICachedRegion getRegion(int n, int n2) {
        return this.a(n, n2);
    }

    class PackerThread
    implements Runnable {
        private /* synthetic */ CachedWorld a;

        PackerThread(CachedWorld cachedWorld) {
            this.a = cachedWorld;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = (class_1923)this.a.a.take();
                        object = ChunkPacker.a((class_2818)this.a.a.remove(object));
                        this.a.b(object.b >> 5, object.c >> 5).a(object.b & 0x1F, object.c & 0x1F, (CachedChunk)object);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

