/*
 * Decompiled with CFR 0.152.
 */
package baritone.command.defaults;

import baritone.Baritone;
import baritone.api.IBaritone;
import baritone.api.cache.IWaypoint;
import baritone.api.cache.IWaypoint$Tag;
import baritone.api.cache.IWorldData;
import baritone.api.cache.Waypoint;
import baritone.api.command.Command;
import baritone.api.command.IBaritoneChatControl;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForWaypoints;
import baritone.api.command.datatypes.RelativeBlockPos;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.command.helpers.Paginator;
import baritone.api.command.helpers.TabCompleteHelper;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.utils.BetterBlockPos;
import baritone.command.defaults.WaypointsCommand$Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;

public class WaypointsCommand
extends Command {
    private Map<IWorldData, List<IWaypoint>> a = new HashMap<IWorldData, List<IWaypoint>>();

    public WaypointsCommand(IBaritone iBaritone) {
        super(iBaritone, "waypoints", "waypoint", "wp");
    }

    @Override
    public void execute(String string, IArgConsumer iArgConsumer) {
        WaypointsCommand$Action waypointsCommand$Action2 = iArgConsumer.hasAny() ? WaypointsCommand$Action.a(iArgConsumer.getString()) : WaypointsCommand$Action.a;
        if (waypointsCommand$Action2 == null) {
            throw new CommandInvalidTypeException(iArgConsumer.consumed(), "an action");
        }
        Object object2 = (iWaypoint, waypointsCommand$Action) -> {
            class_2585 class_25852 = new class_2585("");
            class_2585 class_25853 = new class_2585(iWaypoint.getTag().name() + " ");
            class_25853.method_10862(class_25853.method_10866().method_10977(class_124.field_1080));
            String string2 = iWaypoint.getName();
            class_2585 class_25854 = new class_2585(!string2.isEmpty() ? string2 : "<empty>");
            class_25854.method_10862(class_25854.method_10866().method_10977(!string2.isEmpty() ? class_124.field_1080 : class_124.field_1063));
            string2 = new class_2585(" @ " + new Date(iWaypoint.getCreationTimestamp()));
            string2.method_10862(string2.method_10866().method_10977(class_124.field_1063));
            class_25852.method_10852((class_2561)class_25853);
            class_25852.method_10852((class_2561)class_25854);
            class_25852.method_10852((class_2561)string2);
            class_2585 class_25855 = class_25852;
            class_25855.method_10862(class_25855.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585("Click to select"))).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s %s %s @ %d", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, waypointsCommand$Action.a[0], iWaypoint.getTag().getName(), iWaypoint.getCreationTimestamp()))));
            return class_25852;
        };
        Function<IWaypoint, class_2561> function = iWaypoint -> (class_2561)object2.apply(iWaypoint, waypointsCommand$Action2 == WaypointsCommand$Action.a ? WaypointsCommand$Action.d : waypointsCommand$Action2);
        if (waypointsCommand$Action2 == WaypointsCommand$Action.a) {
            IWaypoint[] iWaypointArray;
            IWaypoint$Tag iWaypoint$Tag = iArgConsumer.hasAny() ? IWaypoint$Tag.getByName(iArgConsumer.peekString()) : null;
            if (iWaypoint$Tag != null) {
                iArgConsumer.get();
            }
            if ((iWaypointArray = iWaypoint$Tag != null ? ForWaypoints.getWaypointsByTag(this.baritone, iWaypoint$Tag) : ForWaypoints.getWaypoints(this.baritone)).length > 0) {
                iArgConsumer.requireMax(1);
                Paginator.paginate(iArgConsumer, iWaypointArray, () -> this.logDirect(iWaypoint$Tag != null ? String.format("All waypoints by tag %s:", iWaypoint$Tag.name()) : "All waypoints:"), function, String.format("%s%s %s%s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, waypointsCommand$Action2.a[0], iWaypoint$Tag != null ? " " + iWaypoint$Tag.getName() : ""));
                return;
            }
            iArgConsumer.requireMax(0);
            throw new CommandInvalidStateException(iWaypoint$Tag != null ? "No waypoints found by that tag" : "No waypoints found");
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.c) {
            IWaypoint$Tag iWaypoint$Tag = iArgConsumer.hasAny() ? IWaypoint$Tag.getByName(iArgConsumer.peekString()) : null;
            if (iWaypoint$Tag == null) {
                iWaypoint$Tag = IWaypoint$Tag.USER;
            } else {
                iArgConsumer.get();
            }
            String string2 = iArgConsumer.hasExactlyOne() || iArgConsumer.hasExactly(4) ? iArgConsumer.getString() : "";
            BetterBlockPos betterBlockPos = iArgConsumer.hasAny() ? (BetterBlockPos)((Object)iArgConsumer.getDatatypePost(RelativeBlockPos.INSTANCE, this.ctx.playerFeet())) : this.ctx.playerFeet();
            iArgConsumer.requireMax(0);
            Waypoint waypoint = new Waypoint(string2, iWaypoint$Tag, betterBlockPos);
            ForWaypoints.waypoints(this.baritone).addWaypoint(waypoint);
            class_2585 class_25852 = new class_2585("Waypoint added: ");
            class_25852.method_10862(class_25852.method_10866().method_10977(class_124.field_1080));
            class_25852.method_10852((class_2561)object2.apply(waypoint, WaypointsCommand$Action.d));
            this.logDirect(new class_2561[]{class_25852});
            return;
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.b) {
            class_2585 class_25853;
            iArgConsumer.requireMax(1);
            IWaypoint$Tag iWaypoint$Tag = IWaypoint$Tag.getByName(iArgConsumer.getString());
            class_2585 class_25854 = class_25853 = ForWaypoints.getWaypointsByTag(this.baritone, iWaypoint$Tag);
            int n = ((IWaypoint[])class_25853).length;
            for (int i = 0; i < n; ++i) {
                object2 = class_25854[i];
                ForWaypoints.waypoints(this.baritone).removeWaypoint((IWaypoint)object2);
            }
            this.a.computeIfAbsent(this.baritone.getWorldProvider().getCurrentWorld(), iWorldData -> new ArrayList()).addAll(Arrays.asList(class_25853));
            class_25854 = new class_2585(String.format("Cleared %d waypoints, click to restore them", ((IWaypoint[])class_25853).length));
            class_25854.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s restore @ %s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, Stream.of(class_25853).map(iWaypoint -> Long.toString(iWaypoint.getCreationTimestamp())).collect(Collectors.joining(" ")))));
            this.logDirect(new class_2561[]{class_25854});
            return;
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.f) {
            ArrayList<Object> arrayList = new ArrayList();
            List list = this.a.getOrDefault(this.baritone.getWorldProvider().getCurrentWorld(), Collections.emptyList());
            if (iArgConsumer.peekString().equals("@")) {
                iArgConsumer.get();
                block5: while (iArgConsumer.hasAny()) {
                    long l = iArgConsumer.getAs(Long.class);
                    for (Object object2 : list) {
                        if (object2.getCreationTimestamp() != l) continue;
                        arrayList.add(object2);
                        continue block5;
                    }
                }
            } else {
                iArgConsumer.requireExactly(1);
                int n = list.size();
                int n2 = Math.min(n, iArgConsumer.getAs(Integer.class));
                arrayList = new ArrayList(list.subList(n - n2, n));
            }
            arrayList.forEach(ForWaypoints.waypoints(this.baritone)::addWaypoint);
            list.removeIf(arrayList::contains);
            this.logDirect(String.format("Restored %d waypoints", arrayList.size()));
            return;
        }
        class_2585 class_25855 = (class_2585)iArgConsumer.getDatatypeFor(ForWaypoints.INSTANCE);
        IWaypoint iWaypoint2 = null;
        if (iArgConsumer.hasAny() && iArgConsumer.peekString().equals("@")) {
            iArgConsumer.requireExactly(2);
            iArgConsumer.get();
            long l = iArgConsumer.getAs(Long.class);
            for (IWaypoint iWaypoint3 : class_25855) {
                if (iWaypoint3.getCreationTimestamp() != l) continue;
                iWaypoint2 = iWaypoint3;
                break;
            }
            if (iWaypoint2 == null) {
                throw new CommandInvalidStateException("Timestamp was specified but no waypoint was found");
            }
        } else {
            switch (((IWaypoint[])class_25855).length) {
                case 0: {
                    throw new CommandInvalidStateException("No waypoints found");
                }
                case 1: {
                    iWaypoint2 = class_25855[0];
                }
            }
        }
        if (iWaypoint2 == null) {
            iArgConsumer.requireMax(1);
            Paginator.paginate(iArgConsumer, class_25855, () -> this.logDirect("Multiple waypoints were found:"), function, String.format("%s%s %s %s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, waypointsCommand$Action2.a[0], iArgConsumer.consumedString()));
            return;
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.d) {
            this.logDirect(function.apply(iWaypoint2));
            this.logDirect(String.format("Position: %s", new Object[]{iWaypoint2.getLocation()}));
            class_2585 class_25856 = new class_2585("Click to delete this waypoint");
            class_25856.method_10862(class_25856.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s delete %s @ %d", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, iWaypoint2.getTag().getName(), iWaypoint2.getCreationTimestamp()))));
            class_2585 class_25857 = new class_2585("Click to set goal to this waypoint");
            class_25857.method_10862(class_25857.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s goal %s @ %d", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, iWaypoint2.getTag().getName(), iWaypoint2.getCreationTimestamp()))));
            class_2585 class_25858 = new class_2585("Click to show a command to recreate this waypoint");
            class_25858.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("%s%s save %s %s %s %s %s", Baritone.a().prefix.value, string, iWaypoint2.getTag().getName(), iWaypoint2.getName(), iWaypoint2.getLocation().x, iWaypoint2.getLocation().y, iWaypoint2.getLocation().z)));
            class_2585 class_25859 = new class_2585("Click to return to the waypoints list");
            class_25859.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s list", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string)));
            this.logDirect(new class_2561[]{class_25856});
            this.logDirect(new class_2561[]{class_25857});
            this.logDirect(new class_2561[]{class_25858});
            this.logDirect(new class_2561[]{class_25859});
            return;
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.e) {
            ForWaypoints.waypoints(this.baritone).removeWaypoint(iWaypoint2);
            this.a.computeIfAbsent(this.baritone.getWorldProvider().getCurrentWorld(), iWorldData -> new ArrayList()).add(iWaypoint2);
            class_2585 class_258510 = new class_2585("That waypoint has successfully been deleted, click to restore it");
            class_258510.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s restore @ %s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, iWaypoint2.getCreationTimestamp())));
            this.logDirect(new class_2561[]{class_258510});
            return;
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.g) {
            GoalBlock goalBlock = new GoalBlock(iWaypoint2.getLocation());
            this.baritone.getCustomGoalProcess().setGoal(goalBlock);
            this.logDirect(String.format("Goal: %s", goalBlock));
            return;
        }
        if (waypointsCommand$Action2 == WaypointsCommand$Action.h) {
            GoalBlock goalBlock = new GoalBlock(iWaypoint2.getLocation());
            this.baritone.getCustomGoalProcess().setGoalAndPath(goalBlock);
            this.logDirect(String.format("Going to: %s", goalBlock));
        }
    }

    @Override
    public Stream<String> tabComplete(String object, IArgConsumer iArgConsumer) {
        if (iArgConsumer.hasAny()) {
            if (iArgConsumer.hasExactlyOne()) {
                return new TabCompleteHelper().append(WaypointsCommand$Action.a()).sortAlphabetically().filterPrefix(iArgConsumer.getString()).stream();
            }
            object = WaypointsCommand$Action.a(iArgConsumer.getString());
            if (iArgConsumer.hasExactlyOne()) {
                if (object == WaypointsCommand$Action.a || object == WaypointsCommand$Action.c || object == WaypointsCommand$Action.b) {
                    return new TabCompleteHelper().append(IWaypoint$Tag.getAllNames()).sortAlphabetically().filterPrefix(iArgConsumer.getString()).stream();
                }
                if (object == WaypointsCommand$Action.f) {
                    return Stream.empty();
                }
                return iArgConsumer.tabCompleteDatatype(ForWaypoints.INSTANCE);
            }
            if (iArgConsumer.has(3) && object == WaypointsCommand$Action.c) {
                iArgConsumer.get();
                iArgConsumer.get();
                return iArgConsumer.tabCompleteDatatype(RelativeBlockPos.INSTANCE);
            }
        }
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Manage waypoints";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The waypoint command allows you to manage Baritone's waypoints.", "", "Waypoints can be used to mark positions for later. Waypoints are each given a tag and an optional name.", "", "Note that the info, delete, and goal commands let you specify a waypoint by tag. If there is more than one waypoint with a certain tag, then they will let you select which waypoint you mean.", "", "Missing arguments for the save command use the USER tag, creating an unnamed waypoint and your current position as defaults.", "", "Usage:", "> wp [l/list] - List all waypoints.", "> wp <l/list> <tag> - List all waypoints by tag.", "> wp <s/save> - Save an unnamed USER waypoint at your current position", "> wp <s/save> [tag] [name] [pos] - Save a waypoint with the specified tag, name and position.", "> wp <i/info/show> <tag/name> - Show info on a waypoint by tag or name.", "> wp <d/delete> <tag/name> - Delete a waypoint by tag or name.", "> wp <restore> <n> - Restore the last n deleted waypoints.", "> wp <c/clear> <tag> - Delete all waypoints with the specified tag.", "> wp <g/goal> <tag/name> - Set a goal to a waypoint by tag or name.", "> wp <goto> <tag/name> - Set a goal to a waypoint by tag or name and start pathing.");
    }
}

