/*
 * Decompiled with CFR 0.152.
 */
package baritone.command.defaults;

import baritone.api.IBaritone;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.process.IBaritoneProcess;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class ETACommand
extends Command {
    public ETACommand(IBaritone iBaritone) {
        super(iBaritone, "eta");
    }

    @Override
    public void execute(String object, IArgConsumer iArgConsumer) {
        iArgConsumer.requireMax(0);
        if ((IBaritoneProcess)this.baritone.getPathingControlManager().mostRecentInControl().orElse(null) == null) {
            throw new CommandInvalidStateException("No process in control");
        }
        object = this.baritone.getPathingBehavior();
        this.logDirect(String.format("Next segment: %.2f\nGoal: %.2f", object.ticksRemainingInSegment().orElse(-1.0), object.estimatedTicksToGoal().orElse(-1.0)));
    }

    @Override
    public Stream<String> tabComplete(String string, IArgConsumer iArgConsumer) {
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "View the current ETA";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The ETA command provides information about the estimated time until the next segment.", "and the goal", "", "Be aware that the ETA to your goal is really unprecise", "", "Usage:", "> eta - View ETA, if present");
    }
}

