/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.Settings;
import baritone.api.Settings$Setting;
import baritone.api.utils.SettingsUtil$Parser;
import baritone.api.utils.SettingsUtil$ParserContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;

public class SettingsUtil {
    private static final Path SETTINGS_PATH = class_310.method_1551().field_1697.toPath().resolve("baritone").resolve("settings.txt");
    private static final Pattern SETTING_PATTERN = Pattern.compile("^(?<setting>[^ ]+) +(?<value>.+)");
    private static final String[] JAVA_ONLY_SETTINGS = new String[]{"logger", "notifier", "toaster"};

    private static boolean isComment(String string) {
        return string.startsWith("#") || string.startsWith("//");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void forEachLine(Path object, Consumer<String> consumer) {
        object = Files.newBufferedReader((Path)object);
        try {
            String string;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.isEmpty() || SettingsUtil.isComment(string)) continue;
                consumer.accept(string);
            }
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((BufferedReader)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((BufferedReader)object).close();
    }

    public static void readAndApply(Settings settings) {
        try {
            SettingsUtil.forEachLine(SETTINGS_PATH, string -> {
                Object object = SETTING_PATTERN.matcher((CharSequence)string);
                if (!((Matcher)object).matches()) {
                    System.out.println("Invalid syntax in setting file: " + string);
                    return;
                }
                String string2 = ((Matcher)object).group("setting").toLowerCase();
                object = ((Matcher)object).group("value");
                try {
                    SettingsUtil.parseAndApply(settings, string2, (String)object);
                    return;
                }
                catch (Exception exception) {
                    System.out.println("Unable to parse line " + string);
                    exception.printStackTrace();
                    return;
                }
            });
            return;
        }
        catch (NoSuchFileException noSuchFileException) {
            System.out.println("Baritone settings file not found, resetting.");
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception while reading Baritone settings, some settings may be reset to default values!");
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void save(Settings iterator) {
        try {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(SETTINGS_PATH, new OpenOption[0]);){
                for (Settings$Setting settings$Setting : SettingsUtil.modifiedSettings(iterator)) {
                    bufferedWriter.write(SettingsUtil.settingToString(settings$Setting) + "\n");
                }
                if (bufferedWriter == null) return;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception thrown while saving Baritone settings!");
            exception.printStackTrace();
            return;
        }
    }

    public static List<Settings$Setting> modifiedSettings(Settings object) {
        ArrayList<Settings$Setting> arrayList = new ArrayList<Settings$Setting>();
        for (Settings$Setting<?> settings$Setting : ((Settings)((Object)object)).allSettings) {
            if (settings$Setting.value == null) {
                System.out.println("NULL SETTING?" + settings$Setting.getName());
                continue;
            }
            if (SettingsUtil.javaOnlySetting(settings$Setting) || settings$Setting.value == settings$Setting.defaultValue) continue;
            arrayList.add(settings$Setting);
        }
        return arrayList;
    }

    public static String settingTypeToString(Settings$Setting settings$Setting) {
        return settings$Setting.getType().getTypeName().replaceAll("(?:\\w+\\.)+(\\w+)", "$1");
    }

    public static <T> String settingValueToString(Settings$Setting<T> settings$Setting, T t) {
        SettingsUtil$Parser settingsUtil$Parser = SettingsUtil$Parser.getParser(settings$Setting.getType());
        if (settingsUtil$Parser == null) {
            throw new IllegalStateException("Missing " + settings$Setting.getValueClass() + " " + settings$Setting.getName());
        }
        return settingsUtil$Parser.toString(new SettingsUtil$ParserContext(settings$Setting), (Object)t);
    }

    public static String settingValueToString(Settings$Setting settings$Setting) {
        Settings$Setting settings$Setting2 = settings$Setting;
        return SettingsUtil.settingValueToString(settings$Setting2, settings$Setting2.value);
    }

    public static String settingDefaultToString(Settings$Setting settings$Setting) {
        Settings$Setting settings$Setting2 = settings$Setting;
        return SettingsUtil.settingValueToString(settings$Setting2, settings$Setting2.defaultValue);
    }

    public static String maybeCensor(int n) {
        if (((Boolean)BaritoneAPI.getSettings().censorCoordinates.value).booleanValue()) {
            return "<censored>";
        }
        return Integer.toString(n);
    }

    public static String settingToString(Settings$Setting settings$Setting) {
        if (SettingsUtil.javaOnlySetting(settings$Setting)) {
            return settings$Setting.getName();
        }
        return settings$Setting.getName() + " " + SettingsUtil.settingValueToString(settings$Setting);
    }

    public static boolean javaOnlySetting(Settings$Setting settings$Setting) {
        String[] stringArray = JAVA_ONLY_SETTINGS;
        int n = JAVA_ONLY_SETTINGS.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!settings$Setting.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static void parseAndApply(Settings settings$Setting, String clazz, String string) {
        SettingsUtil$Parser settingsUtil$Parser;
        settings$Setting = ((Settings)((Object)settings$Setting)).byLowerName.get(clazz);
        if (settings$Setting == null) {
            throw new IllegalStateException("No setting by that name");
        }
        clazz = settings$Setting.getValueClass();
        if (!clazz.isInstance(string = (settingsUtil$Parser = SettingsUtil$Parser.getParser(settings$Setting.getType())).parse(new SettingsUtil$ParserContext(settings$Setting), string))) {
            String string2 = string;
            throw new IllegalStateException(settingsUtil$Parser + " parser returned incorrect type, expected " + clazz + " got " + string2 + " which is " + string2.getClass());
        }
        settings$Setting.value = string;
    }
}

