/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.BaritoneAPI;
import baritone.api.utils.IPlayerContext;
import baritone.api.utils.RayTraceUtils;
import baritone.api.utils.Rotation;
import baritone.api.utils.VecUtils;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4770;
import net.minecraft.class_746;

public final class RotationUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    private static final class_243[] BLOCK_SIDE_MULTIPLIERS = new class_243[]{new class_243(0.5, 0.0, 0.5), new class_243(0.5, 1.0, 0.5), new class_243(0.5, 0.5, 0.0), new class_243(0.5, 0.5, 1.0), new class_243(0.0, 0.5, 0.5), new class_243(1.0, 0.5, 0.5)};

    private RotationUtils() {
    }

    public static Rotation calcRotationFromCoords(class_2338 class_23382, class_2338 class_23383) {
        return RotationUtils.calcRotationFromVec3d(new class_243((double)class_23382.method_10263(), (double)class_23382.method_10264(), (double)class_23382.method_10260()), new class_243((double)class_23383.method_10263(), (double)class_23383.method_10264(), (double)class_23383.method_10260()));
    }

    public static Rotation wrapAnglesToRelative(Rotation rotation, Rotation rotation2) {
        if (rotation.yawIsReallyClose(rotation2)) {
            return new Rotation(rotation.getYaw(), rotation2.getPitch());
        }
        return rotation2.subtract(rotation).normalize().add(rotation);
    }

    public static Rotation calcRotationFromVec3d(class_243 class_2432, class_243 class_2433, Rotation rotation) {
        return RotationUtils.wrapAnglesToRelative(rotation, RotationUtils.calcRotationFromVec3d(class_2432, class_2433));
    }

    private static Rotation calcRotationFromVec3d(class_243 object, class_243 class_2432) {
        double[] dArray = new double[]{object.field_1352 - class_2432.field_1352, object.field_1351 - class_2432.field_1351, object.field_1350 - class_2432.field_1350};
        object = dArray;
        double d = class_3532.method_15349((double)dArray[0], (double)(-object[2]));
        double d2 = Math.sqrt((double)(object[0] * object[0] + object[2] * object[2]));
        double d3 = class_3532.method_15349((double)object[1], (double)d2);
        return new Rotation((float)(d * 57.29577951308232), (float)(d3 * 57.29577951308232));
    }

    public static class_243 calcVector3dFromRotation(Rotation rotation) {
        float f = class_3532.method_15362((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = class_3532.method_15374((float)(-rotation.getYaw() * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -class_3532.method_15362((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        float f4 = class_3532.method_15374((float)(-rotation.getPitch() * ((float)Math.PI / 180)));
        return new class_243((double)(f2 * f3), (double)f4, (double)(f * f3));
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, class_2338 class_23382) {
        return RotationUtils.reachable(iPlayerContext.player(), class_23382, iPlayerContext.playerController().getBlockReachDistance());
    }

    public static Optional<Rotation> reachable(IPlayerContext iPlayerContext, class_2338 class_23382, boolean bl) {
        return RotationUtils.reachable(iPlayerContext.player(), class_23382, iPlayerContext.playerController().getBlockReachDistance(), bl);
    }

    public static Optional<Rotation> reachable(class_746 class_7462, class_2338 class_23382, double d) {
        return RotationUtils.reachable(class_7462, class_23382, d, false);
    }

    public static Optional<Rotation> reachable(class_746 class_7462, class_2338 class_23382, double d, boolean bl) {
        class_239 class_2392;
        Optional<Rotation> optional;
        if (BaritoneAPI.getProvider().getBaritoneForPlayer(class_7462).getPlayerContext().isLookingAt(class_23382)) {
            optional = new Rotation(class_7462.method_36454(), class_7462.method_36455() + 1.0E-4f);
            if (bl) {
                class_2392 = RayTraceUtils.rayTraceTowards((class_1297)class_7462, (Rotation)((Object)optional), d, true);
                if (class_2392 != null && class_2392.method_17783() == class_239.class_240.field_1332 && ((class_3965)class_2392).method_17777().equals((Object)class_23382)) {
                    return Optional.of(optional);
                }
            } else {
                return Optional.of(optional);
            }
        }
        if ((optional = RotationUtils.reachableCenter((class_1297)class_7462, class_23382, d, bl)).isPresent()) {
            return optional;
        }
        class_2392 = class_7462.field_6002.method_8320(class_23382).method_26218((class_1922)class_7462.field_6002, class_23382);
        if (class_2392.method_1110()) {
            class_2392 = class_259.method_1077();
        }
        class_243[] class_243Array = BLOCK_SIDE_MULTIPLIERS;
        int n = BLOCK_SIDE_MULTIPLIERS.length;
        for (int i = 0; i < n; ++i) {
            optional = class_243Array[i];
            double d2 = class_2392.method_1091(class_2350.class_2351.field_11048) * ((class_243)optional).field_1352 + class_2392.method_1105(class_2350.class_2351.field_11048) * (1.0 - ((class_243)optional).field_1352);
            double d3 = class_2392.method_1091(class_2350.class_2351.field_11052) * ((class_243)optional).field_1351 + class_2392.method_1105(class_2350.class_2351.field_11052) * (1.0 - ((class_243)optional).field_1351);
            double d4 = class_2392.method_1091(class_2350.class_2351.field_11051) * ((class_243)optional).field_1350 + class_2392.method_1105(class_2350.class_2351.field_11051) * (1.0 - ((class_243)optional).field_1350);
            optional = RotationUtils.reachableOffset((class_1297)class_7462, class_23382, new class_243((double)class_23382.method_10263(), (double)class_23382.method_10264(), (double)class_23382.method_10260()).method_1031(d2, d3, d4), d, bl);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableOffset(class_1297 class_12972, class_2338 class_23382, class_243 object, double d, boolean bl) {
        object = RotationUtils.calcRotationFromVec3d(bl ? RayTraceUtils.inferSneakingEyePosition(class_12972) : class_12972.method_5836(1.0f), object, new Rotation(class_12972.method_36454(), class_12972.method_36455()));
        class_239 class_2392 = RayTraceUtils.rayTraceTowards(class_12972, (Rotation)object, d, bl);
        if (class_2392 != null && class_2392.method_17783() == class_239.class_240.field_1332) {
            if (((class_3965)class_2392).method_17777().equals((Object)class_23382)) {
                return Optional.of(object);
            }
            if (class_12972.field_6002.method_8320(class_23382).method_26204() instanceof class_4770 && ((class_3965)class_2392).method_17777().equals((Object)class_23382.method_10074())) {
                return Optional.of(object);
            }
        }
        return Optional.empty();
    }

    public static Optional<Rotation> reachableCenter(class_1297 class_12972, class_2338 class_23382, double d, boolean bl) {
        return RotationUtils.reachableOffset(class_12972, class_23382, VecUtils.calculateBlockCenter(class_12972.field_6002, class_23382), d, bl);
    }
}

