/*
 * Decompiled with CFR 0.152.
 */
package com.betterleather.worldgen;

import com.betterleather.init.LeatherBlocks;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateEnd(World world, Random random, int x, int z) {
    }

    private void generateSurface(World world, Random random, int x, int z) {
        this.addOreSpawn(LeatherBlocks.molten_ore, world, random, x, z, 16, 16, 4 + random.nextInt(3), 6, 10, 64);
        this.addOreSpawn(LeatherBlocks.unobtainium_ore, world, random, x, z, 16, 16, 4 + random.nextInt(3), 6, 10, 64);
    }

    private void generateNether(World world, Random random, int x, int z) {
    }

    public void addOreSpawn(Block block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        int maxPossY = minY + (maxY - 1);
        assert (maxY > minY) : "The maximum Y must be greater than the Minimum Y";
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (minY > 0) : "addOreSpawn: The Minimum Y must be greater than 0";
        assert (maxY < 256 && maxY > 0) : "addOreSpawn: The Maximum Y must be less than 256 but greater than 0";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
            new WorldGenMinable(state, maxVeinSize, (Predicate)BlockHelper.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addEndOreSpawn(Block block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        int maxPossY = minY + (maxY - 1);
        assert (maxY > minY) : "The maximum Y must be greater than the Minimum Y";
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (minY > 0) : "addOreSpawn: The Minimum Y must be greater than 0";
        assert (maxY < 256 && maxY > 0) : "addOreSpawn: The Maximum Y must be less than 256 but greater than 0";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
            new WorldGenMinable(state, maxVeinSize, (Predicate)BlockHelper.func_177642_a((Block)Blocks.field_150377_bs)).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addNetherOreSpawn(Block block, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        int maxPossY = minY + (maxY - 1);
        assert (maxY > minY) : "The maximum Y must be greater than the Minimum Y";
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (minY > 0) : "addOreSpawn: The Minimum Y must be greater than 0";
        assert (maxY < 256 && maxY > 0) : "addOreSpawn: The Maximum Y must be less than 256 but greater than 0";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
            new WorldGenMinable(state, maxVeinSize, (Predicate)BlockHelper.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addCustomOreSpawn(Block block, Block custom, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        int maxPossY = minY + (maxY - 1);
        assert (maxY > minY) : "The maximum Y must be greater than the Minimum Y";
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (minY > 0) : "addOreSpawn: The Minimum Y must be greater than 0";
        assert (maxY < 256 && maxY > 0) : "addOreSpawn: The Maximum Y must be less than 256 but greater than 0";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        int diffBtwnMinMaxY = maxY - minY;
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
            new WorldGenMinable(state, maxVeinSize, (Predicate)BlockHelper.func_177642_a((Block)custom)).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

