/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.container;

import com.google.common.collect.Lists;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SpruceTextures;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.MenuBackground;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.border.MenuBorder;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidgetWithBorder;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.container.AbstractSpruceParentWidget;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public abstract class SpruceEntryListWidget<E extends Entry>
extends AbstractSpruceParentWidget<E>
implements WithBackground,
SpruceWidgetWithBorder {
    protected final Position anchor = Position.of(this, 0, 0);
    private final List<E> entries = new Entries();
    private final int anchorYOffset;
    private double scrollAmount;
    private Background background = MenuBackground.MENU_LIST;
    private boolean renderTransition = false;
    private Border border;
    private boolean scrolling = false;
    private boolean allowOutsideHorizontalNavigation = false;

    public SpruceEntryListWidget(Position position, int width, int height, int anchorYOffset, Class<E> entryClass) {
        super(position, entryClass);
        this.width = width;
        this.height = height;
        this.anchorYOffset = anchorYOffset;
        this.anchor.setRelativeY(anchorYOffset);
        this.setBorder(MenuBorder.LIST);
    }

    public int getInnerWidth() {
        int width = this.getInnerBorderedWidth();
        if (this.getMaxScroll() > 0) {
            width -= 6;
        }
        return width;
    }

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Background background) {
        this.background = background;
    }

    public boolean shouldRenderTransition() {
        return this.renderTransition;
    }

    public void setRenderTransition(boolean render) {
        this.renderTransition = render;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        this.anchor.setRelativeX(border.getLeft());
        if (this.anchor.getRelativeY() == this.anchorYOffset && this.getBorder().getTop() != 0) {
            this.anchor.setRelativeY(this.anchorYOffset + this.getBorder().getTop());
        }
    }

    public boolean doesAllowOutsideHorizontalNavigation() {
        return this.allowOutsideHorizontalNavigation;
    }

    public void setAllowOutsideHorizontalNavigation(boolean allowOutsideHorizontalNavigation) {
        this.allowOutsideHorizontalNavigation = allowOutsideHorizontalNavigation;
    }

    protected int getLengthUntil(int index) {
        int max = 0;
        for (int i = 0; i <= index; ++i) {
            max += ((Entry)this.entries.get(i)).getHeight();
        }
        return max;
    }

    public int getMaxPosition() {
        return this.getLengthUntil(this.getEntriesCount() - 1);
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
        this.anchor.setRelativeY((int)((double)(this.anchorYOffset + this.getBorder().getThickness()) - this.scrollAmount));
        Iterator<E> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry;
            entry.setVisibleInList((entry = (Entry)iterator.next()).getY() + entry.getHeight() >= this.getY() && entry.getY() <= this.getY() + this.getHeight());
        }
    }

    public void refocusScroll() {
        this.setScrollAmount(this.getScrollAmount());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getHeight() + 8);
    }

    protected int getScrollbarPositionX() {
        return this.getEndInnerBorderedX() - 6;
    }

    public boolean isScrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    @Override
    public List<E> children() {
        return this.entries;
    }

    protected final void clearEntries() {
        this.setFocused(null);
        this.entries.clear();
        this.refocusScroll();
    }

    protected void replaceEntries(Collection<E> newEntries) {
        Entry oldFocused = (Entry)this.getFocused();
        this.entries.clear();
        this.entries.addAll(newEntries);
        if (!newEntries.contains(oldFocused)) {
            this.setFocused(null);
        }
        this.refocusScroll();
    }

    @Nullable
    protected E getEntry(int index) {
        return (E)((Entry)this.children().get(index));
    }

    protected int addEntry(E entry) {
        this.entries.add(entry);
        return this.entries.size() - 1;
    }

    protected boolean removeEntry(E entry) {
        if (this.getFocused() == entry) {
            this.refocusOnRemoval(entry);
        }
        return this.entries.remove(entry);
    }

    protected void refocusOnRemoval(E focused) {
        int i = this.entries.indexOf(focused);
        if (i == -1) {
            return;
        }
        int newIndex = i - 1;
        if (newIndex < 0) {
            newIndex = i;
        }
        if (this.getEntriesCount() == newIndex - 1) {
            this.setFocused(null);
        } else {
            this.setFocused(this.getEntry(newIndex));
        }
    }

    protected int getEntriesCount() {
        return this.children().size();
    }

    protected void ensureVisible(E entry) {
        int k;
        int index = this.children().indexOf(entry);
        int rowTop = this.getRowTop(index);
        int j = rowTop - this.getY() - ((AbstractSpruceWidget)entry).getHeight() - 8;
        if (j < 0) {
            this.scroll(j);
        }
        int nextHeight = 0;
        if (index < this.getEntriesCount() - 1) {
            nextHeight = ((Entry)this.children().get(index + 1)).getHeight();
        }
        if ((k = this.getY() + this.getHeight() - rowTop - ((AbstractSpruceWidget)entry).getHeight() + nextHeight) < 0) {
            this.scroll(-k);
        }
    }

    protected int getRowTop(int index) {
        return this.getY() + 4 - (int)this.getScrollAmount() + this.getLengthUntil(index);
    }

    @Override
    protected void setOwnerShip(E entry) {
        ((AbstractSpruceWidget)entry).getPosition().setAnchor(this.anchor);
        ((Entry)entry).setVisibleInList(entry.getY() + ((AbstractSpruceWidget)entry).getHeight() >= this.getY() && entry.getY() <= this.getY() + this.getHeight());
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (direction.isHorizontal() && this.getFocused() != null) {
            boolean result = ((Entry)this.getFocused()).onNavigation(direction, tab);
            return !this.allowOutsideHorizontalNavigation || result;
        }
        boolean result = super.onNavigation(direction, tab);
        if (result) {
            this.ensureVisible((Entry)this.getFocused());
        }
        return result;
    }

    @Override
    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPositionX() && mouseX < (double)(this.getScrollbarPositionX() + 6);
        return super.onMouseClick(mouseX, mouseY, button) || this.scrolling;
    }

    @Override
    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.onMouseDrag(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.getY()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)(this.getY() + this.getHeight())) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int height = this.height;
                int j = class_3532.method_15340((int)((int)((float)(height * height) / (float)this.getMaxPosition())), (int)32, (int)(height - 8));
                double e = Math.max(1.0, d / (double)(height - j));
                this.setScrollAmount(this.getScrollAmount() + deltaY * e);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.onMouseScroll(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        this.setScrollAmount(this.getScrollAmount() - scrollY * ((double)this.getMaxPosition() / (double)this.getEntriesCount()) / 2.0);
        return true;
    }

    @Override
    protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.getBackground().render(graphics, this, 0, mouseX, mouseY, delta);
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int left = this.getInnerBorderedX();
        int right = this.getEndInnerBorderedX();
        int top = this.getInnerBorderedY();
        int bottom = this.getEndInnerBorderedY();
        graphics.enableScissor(left, top, right, bottom);
        this.entries.forEach(e -> e.render(graphics, mouseX, mouseY, delta));
        graphics.disableScissor();
        if (this.shouldRenderTransition()) {
            int gradientStart = -16777216;
            boolean gradientEnd = false;
            graphics.fillGradient(left, top, right, top + 4, -16777216, -16777216, 0, 0);
            graphics.fillGradient(right - 4, top, right, bottom, 0, -16777216, -16777216, 0);
            graphics.fillGradient(left, bottom - 4, right, bottom, 0, 0, -16777216, -16777216);
            graphics.fillGradient(left, top, left + 4, bottom, -16777216, 0, 0, -16777216);
        }
        this.renderScrollbar(graphics);
        this.getBorder().render(graphics, this, mouseX, mouseY, delta);
    }

    protected void renderScrollbar(SpruceGuiGraphics graphics) {
        if (this.isScrollbarVisible()) {
            int top = this.getInnerBorderedY();
            int height = this.getInnerBorderedHeight();
            int scrollbarX = this.getScrollbarPositionX();
            int scrollerHeight = (int)((float)(height * height) / (float)this.getMaxPosition());
            scrollerHeight = class_3532.method_15340((int)scrollerHeight, (int)32, (int)(height - 8));
            int scrollbarY = (int)this.getScrollAmount() * (height - scrollerHeight) / this.getMaxScroll() + top;
            if (scrollbarY < top) {
                scrollbarY = top;
            }
            graphics.drawSprite(class_10799.field_56883, SpruceTextures.SCROLLER_BACKGROUND, scrollbarX, top, 6, this.getInnerBorderedHeight());
            graphics.drawSprite(class_10799.field_56883, SpruceTextures.SCROLLER, scrollbarX, scrollbarY, 6, scrollerHeight);
        }
    }

    protected void appendPositionNarrations(class_6382 builder, E entry) {
        int i;
        List<E> list = this.children();
        if (list.size() > 1 && (i = list.indexOf(entry)) != -1) {
            builder.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    @Environment(value=EnvType.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final List<E> entries = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public E get(int i) {
            return (Entry)this.entries.get(i);
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public E set(int i, E entry) {
            Entry entry2 = (Entry)this.entries.set(i, entry);
            this.recomputePositions();
            SpruceEntryListWidget.this.setOwnerShip(entry);
            return entry2;
        }

        @Override
        public void add(int i, E entry) {
            this.entries.add(i, entry);
            this.recomputePositions();
            SpruceEntryListWidget.this.setOwnerShip(entry);
        }

        @Override
        public E remove(int i) {
            Entry result = (Entry)this.entries.remove(i);
            this.recomputePositions();
            return result;
        }

        private void recomputePositions() {
            int y = 0;
            for (Entry entry : this.entries) {
                entry.getPosition().setRelativeY(y);
                y += entry.getHeight();
            }
        }
    }

    public static abstract class Entry
    extends AbstractSpruceWidget {
        private boolean visibleInList = false;

        public Entry() {
            super(Position.origin());
        }

        protected void setVisibleInList(boolean visible) {
            this.visibleInList = visible;
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.visibleInList;
        }
    }
}

