/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.Tooltipable;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.widget.AbstractSpruceButtonWidget;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;

public class SpruceSliderWidget
extends AbstractSpruceButtonWidget
implements Tooltipable {
    private class_2561 baseMessage;
    protected double value;
    private final Consumer<SpruceSliderWidget> applyConsumer;
    private double multiplier;
    private String sign;
    private boolean inUse = false;

    public SpruceSliderWidget(Position position, int width, int height, class_2561 message, double value, Consumer<SpruceSliderWidget> applyConsumer, double multiplier, String sign) {
        super(position, width, height, message);
        this.value = value;
        this.baseMessage = message;
        this.applyConsumer = applyConsumer;
        this.multiplier = multiplier;
        this.sign = sign;
        this.updateMessage();
    }

    public SpruceSliderWidget(Position position, int width, int height, class_2561 message, double progress, Consumer<SpruceSliderWidget> applyConsumer) {
        this(position, width, height, message, progress, applyConsumer, 100.0, "%");
    }

    public double getValue() {
        return this.value;
    }

    private void setValue(double value) {
        double oldValue = this.value;
        this.value = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (oldValue != this.value) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public int getIntValue() {
        return (int)(this.value * this.multiplier);
    }

    public void setIntValue(int value) {
        this.setValue((double)value / this.multiplier);
    }

    public class_2561 getBaseMessage() {
        return this.baseMessage;
    }

    public void setBaseMessage(class_2561 baseMessage) {
        this.baseMessage = baseMessage;
    }

    protected void updateMessage() {
        this.setMessage((class_2561)this.baseMessage.method_27661().method_27693(": " + this.getIntValue() + this.sign));
    }

    protected void applyValue() {
        this.applyConsumer.accept(this);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (direction.isHorizontal() && !tab && (direction.isLookingForward() && this.value < 1.0 || this.value > 0.0)) {
            this.setValue(this.getValue() + (direction.isLookingForward() ? 1.0 / this.multiplier : -(1.0 / this.multiplier)));
            return true;
        }
        return super.onNavigation(direction, tab);
    }

    @Override
    protected void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
        this.inUse = true;
    }

    @Override
    protected void onRelease(double mouseX, double mouseY) {
        if (this.inUse) {
            this.playDownSound();
            this.inUse = false;
        }
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
        this.inUse = true;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.getX() + 4)) / (double)(this.getWidth() - 8));
    }

    @Override
    protected int getVOffset() {
        return 0;
    }

    @Override
    protected void renderButton(class_332 graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_339.field_22757);
        int vOffset = (this.isFocusedOrHovered() ? 2 : 1) * 20;
        graphics.method_25302(class_339.field_22757, this.getX() + (int)(this.value * (double)(this.getWidth() - 8)), this.getY(), 0, 46 + vOffset, 4, 20);
        graphics.method_25302(class_339.field_22757, this.getX() + (int)(this.value * (double)(this.getWidth() - 8)) + 4, this.getY(), 196, 46 + vOffset, 4, 20);
        if (!this.isMouseHovered() && this.inUse) {
            this.inUse = false;
        }
        super.renderButton(graphics, mouseX, mouseY, delta);
    }

    @Override
    protected class_2561 getNarrationMessage() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.getMessage()});
    }

    @Override
    protected class_2561 getNarrationFocusedUsageMessage() {
        return class_2561.method_43471((String)"narration.slider.usage.focused");
    }

    @Override
    protected class_2561 getNarrationHoveredUsageMessage() {
        return class_2561.method_43471((String)"narration.slider.usage.hovered");
    }
}

